# GDS Launcher – KLayout PYA Prototype

## Background and Context

This repository documents a **second research prototype** derived from the same KLayout forum discussion:

https://www.klayout.de/forum/discussion/2834/

In the forum thread, the original poster (Simran) proposed *developing a KLayout plug‑in* that:

- Authenticates via REST APIs
- Downloads a GDSII file
- Loads the file programmatically into KLayout

In the **first prototype**, this idea was explored using an **external PySide6 GUI launcher**
that invokes KLayout as a separate process.

This repository represents a **parallel and alternative interpretation** of that proposal.

---

## Interpretation of “Plugin”

The term *plugin* used in the forum discussion is somewhat ambiguous.

Based on Matthias’s responses and KLayout’s actual extension model, this prototype interprets
*“plugin”* as:

> **A GUI dialog implemented in Python (PYA) and registered in the KLayout main menu**

That is:

- **No external launcher**
- **No command‑line invocation of KLayout**
- **No Ruby or binary plugin**
- A **menu‑integrated GUI implemented in PYA**, running *inside KLayout*

This interpretation aligns with what KLayout practically supports and what Matthias describes
as feasible.

---

## Key Difference from the PySide Prototype

| Aspect | PySide Prototype (Launcher1) | This Prototype (Launcher2) |
|------|------------------------------|----------------------------|
| GUI | External PySide6 application | PYA dialog inside KLayout |
| KLayout role | External tool, launched | Host application |
| Integration | Command‑line invocation | Menu‑registered UI |
| Plugin concept | Explicitly *not* a plugin | Interpreted as KLayout “plugin” |
| Backend | Same mock REST server | Same mock REST server |
| Test data | Same | Same |

The **mock backend server and test data are reused unchanged** from the PySide version.

---

## Authorship and Contribution Note

This prototype was developed through an interactive, AI-assisted design process.

- The UI design and overall integration account for approximately **70%** of the implementation and were authored by the human contributor.
- The remaining **30%**, primarily the **server communication logic inside `OpenInKLayout`**
  (authentication, REST interaction, error handling, and download flow),
  was generated by **ChatGPT (GPT-5.2)** based on iterative requirements, reviews, and testing feedback.

Human contributions focused on:

- Architectural decisions and constraints
- Interpretation of the term “plugin” in the context of KLayout
- UI behavior, read-only policy, and user interaction rules
- Step-by-step testing, debugging, and validation

ChatGPT contributions focused on:

- REST client structure and control flow
- Error classification and user-facing error messages
- URL normalization and robustness improvements
- Incremental refinements based on observed runtime behavior

This explicit attribution is included to clarify authorship
and to document this work as an experiment in AI-assisted software development.

---
## Design Philosophy

### 1. Menu‑Integrated UI via PYA

The GUI is implemented using Qt via **KLayout’s Python API (PYA)** and is:

- Registered in the KLayout menu
- Launched explicitly by the user
- Fully contained within the KLayout process

This avoids:

- OS‑specific external launch scripts
- Ambiguity around file association or File/Open hooks
- Hidden or implicit automation

---

### 2. Explicit, Read‑Only UI

All fields derived from the XML input (e.g. `GdsRefId`) are **read‑only**.

This is intentional:

- The XML file is the **single source of truth**
- Manual editing inside the UI would defeat reproducibility
- The dialog acts as a **viewer and executor**, not an editor

Read‑only fields are visually explained using tooltips/balloons rather than being silently disabled.

---

### 3. Synchronous, Simple Execution Model (Server Communication)

Unlike the PySide prototype, server communication in this prototype is intentionally implemented in a simple, synchronous manner:

- No worker threads are used for REST communication
- No Qt signals/slots are used to manage server-side asynchronous workflows
- No background tasks are spawned for authentication, lookup, or download

All server-related operations (authentication, reference lookup, file download) are executed synchronously within the dialog logic.

This design choice is intentional for this research prototype:

- It keeps the control flow explicit and easy to trace
- It simplifies debugging and error classification
- It avoids threading and signal/slot complexity inside KLayout’s embedded Python environment

Qt signals/slots may still be used elsewhere for local UI interaction, but they are deliberately not used as a mechanism for REST or network concurrency.


---

## Workflow Overview

1. User opens the dialog from the KLayout menu.
2. A recipe XML file containing `<GdsRefId>` is loaded.
3. User enters server URL and credentials.
4. Authentication is performed via REST.
5. The backend resolves the reference ID.
6. Matching **GDS** and **LYP** files are downloaded.
7. Files are stored in a temporary directory.
8. The layout is opened in the current KLayout session and the LYP is applied.

---

## XML Input Format

Same as the PySide prototype.

Example:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<Root>
    <GdsRefId>TEST-GDS-002</GdsRefId>
</Root>
```

---

## Mock Backend Server

The **mock backend server is reused without modification** from the PySide prototype.

Endpoints:

- `POST /api/auth/login`
- `GET  /api/layouts/by-ref/<GdsRefId>`
- `GET  /download/<GdsRefId>.gds`
- `GET  /download/<GdsRefId>.lyp`

Startup examples:

```bash
# Same machine
./mock_backend.py --host 127.0.0.1 --port 8000

# Different machine on LAN
./mock_backend.py --host 0.0.0.0 --port 8000
```

Credentials (example):

```bash
MOCK_USER=simran MOCK_PASS=simran ./mock_backend.py --host 0.0.0.0 --port 8000
```

---

## Test Data

The test data is **identical to the PySide prototype** and is reused as‑is.

| GdsRefId | GDS | LYP | Notes |
|---------|-----|-----|------|
| TEST-GDS-001 | sample.gds | sample.lyp | Minimal test layout |
| TEST-GDS-002 | cobra3b.gds | cobra3b.lyp | Realistic layout from Forum #2827 (Kazzz‑S) |

---

## Error Handling

Errors are intentionally classified and displayed explicitly:

- **401 / 403** – Authentication failed
- **404** – Reference ID not found
- **5xx** – Server error (details in log)
- **Network errors** – Connection or routing failures

This makes configuration mistakes (wrong IP, wrong password, firewall issues) immediately obvious.

---

## Platform Notes and Limitations

This prototype was also tested on **Windows builds of KLayout**, but it does **not function correctly** there.

This behavior is consistent with Matthias’s earlier comments in the forum discussion and is
most likely caused by **module and packaging limitations of the Python environment bundled with Windows KLayout**.

In particular:

- The Windows KLayout distribution ships with a restricted, self-contained Python environment
- Adding or relying on external Python modules for REST communication is significantly constrained
- As a result, the same PYA-based implementation that works on macOS and Linux fails on Windows

### Test Environment (Confirmed Working)

- Mock backend server: **Linux Mint 21.3**
- Client machine: **macOS Tahoe (Apple Silicon)**
- KLayout: Qt6-based build

The macOS and Linux environments allow sharing or extending the system Python environment
more flexibly, which makes this approach viable there.

This limitation further supports the architectural motivation discussed in the forum:
for cross-platform robustness (especially Windows),
an external launcher approach may be preferable.

---

## Notes

- This prototype is intended for **architectural exploration**, not production use.
- It demonstrates how the same REST‑based workflow can be integrated **inside KLayout**
  without relying on external launchers.
- Together with the PySide prototype, it provides a concrete comparison of two viable designs
  discussed in the forum thread.

---

End of document.
