#!/usr/bin/env python3

#----------------------------------------------------------------------------------------
# Ref. https://www.klayout.de/forum/discussion/2543
# Sub. How to convert gds to dxf (using convert options. Set layerName, layer Color...)
# Posted by: jun
#----------------------------------------------------------------------------------------
# For the 'dump_oas_gds2' tool,
#   Ref. https://www.klayout.de/forum/discussion/comment/10551/#Comment_10551
#        https://github.com/klayoutmatthias/dump_oas_gds2
#
# 'ringo.gds' is from 'klayout/testdata/lvs/ringo.gds'
#----------------------------------------------------------------------------------------
# Author: Kazzz-S
# Dated: 2024-07-09
#----------------------------------------------------------------------------------------
import sys
import re

dicLayerFwd = dict()
dicLayerRev = dict()
idx = 1

def Usage():
    print( "Usage: on Linux or Mac" )
    print( "  $ dump_gds2 ringo.gds | f2543Filter.py [-r|-d]" )
    print( "" )

def ProcessInput( keyword, mode ):
    global dicLayerFwd
    global dicLayerRev
    global idx
    lines = sys.stdin.readlines()
    for i in range(len(lines) - 1):
        if keyword in lines[i]:
            if mode == "dump":
                print( lines[i].strip("\n") )
                print( lines[i + 1].strip("\n") )
            # 000009196   00 09                      9
            words = re.split(r'\s+', lines[i + 1].strip("\n"))
            lay = int(words[3])
            try:
                val = dicLayerFwd[lay]
            except KeyError: # new entry
                dicLayerFwd[lay] = idx
                dicLayerRev[idx] = lay
                idx += 1
            else:
                pass

def Main():
    if len(sys.argv) == 1:
        Usage()
        sys.exit(0)
    elif sys.argv[1] == '-r':
        mode = "run"
    elif sys.argv[1] == '-d':
        mode = "dump"
    else:
        Usage()
        sys.exit(0)

    keyword = "LAYER"
    ProcessInput( keyword, mode )
    for key in sorted(dicLayerRev.keys()):
        val = dicLayerRev[key]
        print("idx=%d: layer=%d" % (key, val) )

if __name__ == "__main__":
    Main()
