#!/usr/bin/env python3

#----------------------------------------------------------------------------------------
# Ref. https://www.klayout.de/forum/discussion/2543
# Sub. How to convert gds to dxf (using convert options. Set layerName, layer Color...)
# Posted by: jun
#----------------------------------------------------------------------------------------
# Also,
#   Ref. https://www.klayout.de/forum/discussion/2514
#   Sub. Klayout gds to dxf conversion problem
#   Posted by: wildwolfcj
#----------------------------------------------------------------------------------------
# Author: Kazzz-S
# Dated: 2024-07-11
#----------------------------------------------------------------------------------------
import klayout.db as db

##
## The main function
##
def Main():
    # [1] Set the input and output file names.
    #     The output file format is OASIS to hold the new layer names in it.
    #     GDS2 cannot do that (only L/D).
    inputDXF  = "ringo-fruits.dxf"
    outputOAS = "ringo-fruits.oas"

    # [2] Prepare the layer map.
    layerMap  = db.LayerMap()
    #              in DXF    : in OASIS
    layerMap.map( "Apple     : delicious_Apple      (10/0)" )
    layerMap.map( "Banana    : delicious_Banana     (20/0)" )
    layerMap.map( "Cherry    : delicious_Cherry     (30/0)" )
    layerMap.map( "Date      : delicious_Date       (40/0)" )
    layerMap.map( "Elderberry: delicious_Elderberry (50/0)" )
    layerMap.map( "Fig       : delicious_Fig        (60/0)" )
    layerMap.map( "Grape     : delicious_Grape      (70/0)" )
    layerMap.map( "Honeydew  : delicious_Honeydew   (80/0)" )
    layerMap.map( "Kiwi      : delicious_Kiwi       (90/0)" )
    layerMap.map( "Lemon     : delicious_Lemon      (100/0)" )
    layerMap.map( "Mango     : delicious_Mango      (110/0)" )
    layerMap.map( "Orange    : delicious_Orange     (120/0)" )

    # [3] Set the major load layout options for reading the DXF file.
    lo = db.LoadLayoutOptions()
    lo.dxf_layer_map     = layerMap
    lo.dxf_unit          = 1000.0   # [um] = 1.0[mm]
    lo.dxf_dbu           = 0.001    # [um] = 1.0[nm]
    lo.dxf_circle_points = 128
    lo.dxf_polyline_mode = 0        # 0 (automatic),
                                    # 1 (keep lines),
                                    # 2 (create polygons from closed polylines with width = 0),
                                    # 3 (merge all lines with width = 0 into polygons),
                                    # 4 (as 3 plus auto-close open contours).

    # [4] Load the DXF with the options.
    layout = db.Layout()
    layout.read( inputDXF, lo )

    # [5] Save the layout to the OASIS file.
    so = db.SaveLayoutOptions()
    so.format = "OASIS"
    layout.write( outputOAS, so )


if __name__ == "__main__":
    Main()
